<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Response;

use DateTime;
use IssetBV\VideoPublisherClient\Response\Data\Asset;
use IssetBV\VideoPublisherClient\Response\Data\Playlist;
use IssetBV\VideoPublisherClient\Response\Data\PlaylistResult;
use IssetBV\VideoPublisherClient\Response\Data\Playout;
use IssetBV\VideoPublisherClient\Response\Data\Publish;
use IssetBV\VideoPublisherClient\Response\Data\PublishListResult;

class ResponseConverter
{
    public function convertToPublishResult($jsonData): PublishListResult
    {
        return new PublishListResult(
            $jsonData['total'],
            $jsonData['from'],
            $jsonData['size'],
            array_map([$this, 'convertToPublish'], $jsonData['results'])
        );
    }

    public function convertToPublish(array $jsonData): Publish
    {
        return new Publish(
            $jsonData['uuid'],
            $jsonData['stream_name'],
            $jsonData['status'],
            $jsonData['enabled'],
            new DateTime($jsonData['date_created']),
            $jsonData['viewable'],
            null !== $jsonData['playout'] ? new Playout(
                $jsonData['playout']['playout_url'],
                $jsonData['playout']['playout_player_url'],
                $jsonData['playout']['embed_url'],
                $jsonData['playout']['embed_player_url'],
                $jsonData['playout']['stream_url']
            ) : null,
            $jsonData['identifier'],
            $jsonData['description'],
            array_map(function ($asset) {
                return new Asset($asset['url'], $asset['type'], $asset['status']);
            }, $jsonData['assets']
            )
        );
    }

    public function convertToPlaylistResult(array $jsonData): PlaylistResult
    {
        return new PlaylistResult(
            $jsonData['total'],
            $jsonData['from'],
            $jsonData['size'],
            array_map([$this, 'convertToPlaylist'], $jsonData['results'])
        );
    }

    public function convertToPlaylist($jsonData): Playlist
    {
        return new Playlist(
            $jsonData['name'],
            $jsonData['url']
        );
    }
}
