<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Response\Data;

/**
 * Class Playout.
 *
 * @author Tim Fennis <tim@isset.nl>
 * @author Bart Malestein <bart@isset.nl>
 */
class Playout
{
    /**
     * @var string
     */
    private $playoutUrl;

    /**
     * @var string|null
     */
    private $playoutPlayerUrl;
    /**
     * @var string|null
     */
    private $embedUrl;
    /**
     * @var string|null
     */
    private $embedPlayerUrl;
    /**
     * @var string|null
     */
    private $streamUrl;

    public function __construct(
        string $playoutUrl,
        string $playoutPlayerUrl = null,
        string $embedUrl = null,
        string $embedPlayerUrl = null,
        string $streamUrl = null
    ) {
        $this->playoutUrl = $playoutUrl;
        $this->playoutPlayerUrl = $playoutPlayerUrl;
        $this->embedUrl = $embedUrl;
        $this->embedPlayerUrl = $embedPlayerUrl;
        $this->streamUrl = $streamUrl;
    }

    /**
     * @return string
     */
    public function getPlayoutUrl(): string
    {
        return $this->playoutUrl;
    }

    /**
     * @return null|string
     */
    public function getPlayoutPlayerUrl()
    {
        return $this->playoutPlayerUrl;
    }

    /**
     * @return null|string
     */
    public function getEmbedUrl()
    {
        return $this->embedUrl;
    }

    /**
     * @return null|string
     */
    public function getEmbedPlayerUrl()
    {
        return $this->embedPlayerUrl;
    }

    /**
     * @return null|string
     */
    public function getStreamUrl()
    {
        return $this->streamUrl;
    }
}
