<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Response\Data;

/**
 * Class Asset.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class Asset
{
    /**
     * @var string
     */
    private $url;
    /**
     * @var string
     */
    private $type;
    /**
     * @var string
     */
    private $status;

    public function __construct(string $url, string $type, string $status)
    {
        $this->url = $url;
        $this->type = $type;
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return $this->url;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }
}
