<?php

declare(strict_types=1);

namespace IssetBV\VideoPublisherClient\Request\Ftp;

use IssetBV\VideoPublisherClient\Request\FileInterface;

class FileFtp implements FileInterface
{
    /**
     * @var string
     */
    private $url;
    /**
     * @var string
     */
    private $importType;

    public function __construct(string $url, string $importType = self::TYPE_DEFAULT)
    {
        $this->url = $url;
        $this->importType = $importType;
    }

    public function getLocationData(): array
    {
        $parts = parse_url($this->url);

        return [
            'location' => $parts['host'],
            'path' => ltrim($parts['path'], '/'),
            'user' => $parts['user'],
            'password' => $parts['pass'],
            'type' => 'ftp',
            'import_type' => $this->importType,
        ];
    }
}
