<?php

namespace IssetBV\VideoPublisherClient;

use DateTime;

/**
 * @author Tim Fennis <tim@isset.nl>
 * @author Bart Malestein <bart@isset.nl>
 */
class Publish
{
    /**
     * @var DateTime
     */
    private $dateCreated;

    /**
     * @var bool
     */
    private $enabled;

    /**
     * @var bool
     */
    private $viewable;

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $uuid;

    /**
     * @var Playout|null
     */
    private $playout;

    /**
     * @var string
     */
    private $streamName;

    /**
     * @var string
     */
    private $identifier;

    /**
     * @var string
     */
    private $description;

    /**
     * @var Asset[]
     */
    private $assets;

    /**
     * Publish constructor.
     *
     * @param string $uuid
     * @param string $streamName
     * @param string $status
     * @param bool $enabled
     * @param DateTime $dateCreated
     * @param bool $viewable
     * @param Playout $playout
     * @param $identifier
     * @param $description
     * @param $assets
     */
    public function __construct($uuid, $streamName, $status, $enabled, DateTime $dateCreated, $viewable, Playout $playout = null, $identifier, $description, array $assets)
    {
        $this->uuid = $uuid;
        $this->status = $status;
        $this->enabled = $enabled;
        $this->viewable = $viewable;
        $this->playout = $playout;
        $this->dateCreated = $dateCreated;
        $this->streamName = $streamName;
        $this->identifier = $identifier;
        $this->description = $description;
        $this->assets = $assets;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @return bool
     */
    public function isViewable()
    {
        return $this->viewable;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getStreamName()
    {
        return $this->streamName;
    }

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @return Asset[]
     */
    public function getAssets()
    {
        return $this->assets;
    }

    /**
     * @return Playout|null
     */
    public function getPlayout()
    {
        return $this->playout;
    }
}
