<?php

namespace IssetBV\VideoPublisherClient;

/**
 * Class PublishResult.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class PublishResult
{
    /**
     * @var int
     */
    private $total;
    /**
     * @var int
     */
    private $from;
    /**
     * @var int
     */
    private $size;
    /**
     * @var Publish[]
     */
    private $results;

    /**
     * PublishResult constructor.
     * @param int $total
     * @param int $from
     * @param int $size
     * @param Publish[] $results
     */
    public function __construct($total, $from, $size, array $results)
    {
        $this->total = $total;
        $this->from = $from;
        $this->size = $size;
        $this->results = $results;
    }

    /**
     * @return int
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @return int
     */
    public function getFrom()
    {
        return $this->from;
    }

    /**
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @return Publish[]
     */
    public function getResults()
    {
        return $this->results;
    }
}