<?php

namespace IssetBV\VideoPublisherClient;

/**
 * Class Playout
 *
 * @author Tim Fennis <tim@isset.nl>
 * @author Bart Malestein <bart@isset.nl>
 */
class Playout
{
    /**
     * @var string|null
     */
    private $playoutUrl;

    /**
     * @var string|null
     */
    private $playoutPlayerUrl;

    /**
     * View constructor.
     *
     * @param string|null $playoutUrl
     * @param string|null $playoutPlayerUrl
     */
    public function __construct($playoutUrl, $playoutPlayerUrl)
    {
        $this->playoutUrl = $playoutUrl;
        $this->playoutPlayerUrl = $playoutPlayerUrl;
    }

    /**
     * @return string|null
     */
    public function getPlayoutUrl()
    {
        return $this->playoutUrl;
    }

    /**
     * @return string|null
     */
    public function getPlayoutPlayerUrl()
    {
        return $this->playoutPlayerUrl;
    }
}