<?php

namespace IssetBV\VideoPublisherClient;

use DateTime;

/**
 * @author Tim Fennis <tim@isset.nl>
 * @author Bart Malestein <bart@isset.nl>
 */
class Publish
{
    /**
     * @var DateTime
     */
    private $dateCreated;

    /**
     * @var bool
     */
    private $enabled;

    /**
     * @var bool
     */
    private $viewable;

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $uuid;

    /**
     * @var View
     */
    private $view;

    /**
     * Publish constructor.
     *
     * @param string $uuid
     * @param string $status
     * @param bool $enabled
     * @param DateTime $dateCreated
     * @param bool $viewable
     * @param View $view
     */
    public function __construct($uuid, $status, $enabled, DateTime $dateCreated, $viewable, View $view = null)
    {
        $this->uuid = $uuid;
        $this->status = $status;
        $this->enabled = $enabled;
        $this->viewable = $viewable;
        $this->view = $view;
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @return bool
     */
    public function isViewable()
    {
        return $this->viewable;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

    /**
     * @return View
     */
    public function getView()
    {
        return $this->view;
    }
}
