<?php

namespace IssetBV\VideoPublisherClient;

use IssetBV\XAuthClient\Connection\ConnectionInterface;
use IssetBV\XAuthClient\Connection\ResponseInterface;
use IssetBV\XAuthClient\Payload\Payload;

/**
 * Class VideoPublisherConnector
 *
 * @package IssetBV\Niop\AssetBundle\Service
 * @author Bart Malestein <bart@isset.nl>
 * @author Tim Fennis <tim@isset.nl>
 */
class VideoPublisherClient
{
  /**
     * @var ConnectionInterface
     */
    private $connection;

    /**
     * @var string
     */
    private $xAuthToken;

    /**
     * @param ConnectionInterface $connection
     * @param string $xAuthToken
     */
    public function __construct(ConnectionInterface $connection, $xAuthToken)
    {
        $this->connection = $connection;
        $this->xAuthToken = $xAuthToken;
    }

    /**
     * Adds the security and Content-Type headers to the payload before sending them
     *
     * @param Payload $payload
     * @return ResponseInterface
     */
    public function sendPayloadWithHeaders(Payload $payload)
    {
        $this->setRequiredHeadersToPayload($payload);

        return $this->sendPayload($payload);
    }

    /**
     * set the content-type and xauth-token header to a payload
     *
     * @param Payload $payload
     */
    public function setRequiredHeadersToPayload(Payload $payload)
    {
        $payload->setHeader('Content-Type', 'application/json');
        $payload->setHeader('xauth-token', $this->xAuthToken);
    }

    /**
     * @param Payload $payload
     * @return ResponseInterface
     */
    public function sendPayload(Payload $payload)
    {
        return $this->connection->sendPayload($payload);
    }
}