<?php
namespace IssetBV\VideoArchiveClient\Payload;

class PayloadFactory
{

    private $baseUrl;

    public function __construct($baseUrl)
    {
        $this->baseUrl = rtrim($baseUrl, '/');
    }

    public function post($path)
    {
        return $this->createPayload($path, 'post');
    }

    public function put($path)
    {
        return $this->createPayload($path, 'put');
    }

    public function get($path)
    {
        return $this->createPayload($path, 'get');
    }

    public function createPayload($path, $method)
    {
        return new Payload($this->baseUrl . '/' . ltrim($path, '/'), $method);
    }
}