<?php

namespace IssetBV\VideoPublisher\ApiClientBundle\Service;

use IssetBV\VideoPublisher\ApiClientBundle\Payload\LoginPayload;
use IssetBV\XAuthClient\Client;
use IssetBV\XAuthClient\Connection\Curl\CurlPost;
use IssetBV\XAuthClient\Connection\ResponseInterface;
use IssetBV\XAuthClient\Payload\Payload;
use IssetBV\XAuthClient\Security\Token;
use IssetBV\XAuthClient\Security\TokenVault;
use LogicException;

/**
 * Class VideoPublisherConnector
 *
 * @package IssetBV\Niop\AssetBundle\Service
 * @author Bart Malestein <bart@isset.nl>
 * @author Tim Fennis <tim@isset.nl>
 */
class VideoPublisherClient
{
    /**
     * @var string
     */
    private $baseUrl;

    /**
     * @var string
     */
    private $consumerKey;

    /**
     * @var string
     */
    private $privateKey;

    /**
     * @var TokenVault
     */
    private $tokenVault;

    /**
     * VideoPublisherConnector constructor.
     *
     * @param $baseUrl
     * @param $consumerKey
     * @param $privateKey
     * @param $tokenCacheLocation
     */
    public function __construct($baseUrl, $consumerKey, $privateKey, $tokenCacheLocation)
    {
        $this->baseUrl = $baseUrl;
        $this->consumerKey = $consumerKey;
        $this->privateKey = $privateKey;

        $this->tokenVault = new TokenVault($tokenCacheLocation);
    }

    /**
     * @param string $uuid
     * @return ResponseInterface
     */
    public function fetchPublisherData($uuid)
    {
        $payload = new Payload(rtrim($this->baseUrl, '/') . sprintf('/api/publish/%s', $uuid), 'GET');
        $client = new Client(new CurlPost());

        return $client->sendPayloadWithToken($payload, $this->fetchToken());
    }

    /**
     * @return Token
     */
    private function fetchToken()
    {
        try {
            return $this->tokenVault->getToken($this->consumerKey);
        } catch (LogicException $e) {

            $loginPayload = new LoginPayload(rtrim($this->baseUrl, '/') . '/api/login', $this->consumerKey, $this->privateKey);

            $curlPost = new CurlPost();
            $response = $curlPost->sendPayload($loginPayload);

            $data = $response->getJsonResponse();

            $token = new Token($data['token'], 'xauth-token');
            $this->tokenVault->addToken($this->consumerKey, $token);

            return $token;
        }
    }
}