<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClientBundle\Service;

use IssetBV\VideoArchiveClient\VideoArchiveClient;
use IssetBV\VideoArchiveClient\VideoArchiveHttpClient;

class VideoArchiveClientFactory
{
    /**
     * @var VideoArchiveHttpClient
     */
    private $videoArchiveHttpClient;

    /**
     * @var VideoArchiveClient[]
     */
    private $cache = [];

    public function __construct(VideoArchiveHttpClient $videoArchiveHttpClient)
    {
        $this->videoArchiveHttpClient = $videoArchiveHttpClient;
    }

    public function getForToken(string $token): VideoArchiveClient
    {
        if (!array_key_exists($token, $this->cache)) {
            $this->cache[$token] = new VideoArchiveClient($this->videoArchiveHttpClient, $token);
        }

        return $this->cache[$token];
    }
}
