<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\Folder;

use DateTime;
use Psr\Http\Message\ResponseInterface;

class FolderFile
{
    /**
     * @var array
     */
    private $data;
    /**
     * @var string
     */
    private $uuid;
    /**
     * @var string
     */
    private $state;
    /**
     * @var int|null
     */
    private $size;
    /**
     * @var string
     */
    private $name;
    /**
     * @var DateTime
     */
    private $created;
    /**
     * @var DateTime
     */
    private $updated;
    /**
     * @var string|null
     */
    private $image;
    /**
     * @var float|null
     */
    private $duration;
    /**
     * @var string|null
     */
    private $extension;
    /**
     * @var bool
     */
    private $previewCreates;
    /**
     * @var string
     */
    private $previewState;
    /**
     * @var string
     */
    private $previewLink;

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->uuid = $data['uuid'];
        $this->state = $data['state'];
        $this->size = null === $data['size'] ? null : (int) $data['size'];
        $this->name = $data['name'];
        $this->created = new DateTime($data['created']);
        $this->updated = new DateTime($data['updated']);
        $this->image = $data['image'];
        $this->duration = null === $data['duration'] ? null : (float) $data['duration'];
        $this->extension = $data['extension'];
        $this->previewLink = $data['preview_link'];
        $this->previewCreates = (bool) $data['preview_creates'];
        $this->previewState = $data['preview_state'];
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return DateTime
     */
    public function getCreated(): DateTime
    {
        return $this->created;
    }

    /**
     * @return DateTime
     */
    public function getUpdated(): DateTime
    {
        return $this->updated;
    }

    /**
     * @return null|string
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * @return float|null
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * @return null|string
     */
    public function getExtension()
    {
        return $this->extension;
    }

    /**
     * @return bool
     */
    public function isPreviewCreates(): bool
    {
        return $this->previewCreates;
    }

    /**
     * @return string
     */
    public function getPreviewState(): string
    {
        return $this->previewState;
    }

    /**
     * @return string
     */
    public function getPreviewLink(): string
    {
        return $this->previewLink;
    }

    /**
     * @param ResponseInterface $response
     *
     * @return FolderFile
     */
    public static function createFromResponse(ResponseInterface $response): self
    {
        $data = json_decode((string) $response->getBody(), true);

        return new self($data);
    }
}
