<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\File;

class FileFolderData
{
    /**
     * @var array
     */
    private $data;
    /**
     * @var string
     */
    private $uuid;
    /**
     * @var string
     */
    private $owner;
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    private $path;
    /**
     * @var string[]
     */
    private $divisions;

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->uuid = $data['uuid'];
        $this->owner = $data['owner'];
        $this->name = $data['name'];
        $this->path = $data['path'];
        $this->divisions = $data['divisions'];
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getOwner(): string
    {
        return $this->owner;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @return string[]
     */
    public function getDivisions(): array
    {
        return $this->divisions;
    }
}
