<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Request\File;

use JsonSerializable;

class File implements JsonSerializable
{
    /**
     * @var string
     */
    private $name;
    /**
     * @var Meta[]
     */
    private $meta = [];
    /**
     * @var string
     */
    private $location;
    /**
     * @var string|null
     */
    private $folderPath = '/';
    /**
     * @var string|null
     */
    private $callbackUrl;

    /**
     * File constructor.
     *
     * @param string $name
     * @param string $location
     */
    public function __construct(string $name, string $location)
    {
        $this->name = $name;
        $this->location = $location;
    }

    public function addMeta(string $key, string $value)
    {
        $this->meta[] = new Meta($key, $value);
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getLocation(): string
    {
        return $this->location;
    }

    /**
     * @param string $location
     */
    public function setLocation(string $location)
    {
        $this->location = $location;
    }

    /**
     * @return null|string
     */
    public function getFolderPath()
    {
        return $this->folderPath;
    }

    /**
     * @param null|string $folderPath
     */
    public function setFolderPath(string $folderPath = null)
    {
        $this->folderPath = $folderPath;
    }

    /**
     * @return null|string
     */
    public function getCallbackUrl()
    {
        return $this->callbackUrl;
    }

    /**
     * @param null|string $callbackUrl
     */
    public function setCallbackUrl(string $callbackUrl = null)
    {
        $this->callbackUrl = $callbackUrl;
    }

    /**
     * @return Meta[]
     */
    public function getMeta(): array
    {
        return $this->meta;
    }

    public function jsonSerialize()
    {
        return [
            'name' => $this->getName(),
            'meta' => $this->getMeta(),
            'location' => $this->getLocation(),
            'folder_path' => $this->getFolderPath(),
            'callback_url' => $this->getCallbackUrl(),
        ];
    }
}
