<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\Job;

use Psr\Http\Message\ResponseInterface;

class JobData
{
    /**
     * @var array
     */
    private $data;
    /**
     * @var string
     */
    private $jobId;

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->jobId = (string) $data['job_id'];
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return string
     */
    public function getJobId(): string
    {
        return $this->jobId;
    }

    public static function createFromResponse(ResponseInterface $response): self
    {
        $data = json_decode((string) $response->getBody(), true);

        return new self($data);
    }
}
