<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\Folder;

use Psr\Http\Message\ResponseInterface;

class Folder
{
    /**
     * @var string
     */
    private $name;
    /**
     * @var array
     */
    private $data;
    /**
     * @var string
     */
    private $path;
    /**
     * @var string
     */
    private $uuid;
    /**
     * @var string
     */
    private $owner;
    /**
     * @var string[]
     */
    private $divisions;
    /**
     * @var Folder[]
     */
    private $subFolders = [];
    /**
     * @var bool
     */
    private $filesDisplayed;
    /**
     * @var FolderFile[]
     */
    private $files = [];

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->path = $data['path'];
        $this->uuid = $data['uuid'];
        $this->owner = $data['owner'];
        $this->name = $data['name'];
        $this->divisions = $data['divisions'];
        foreach ($data['sub_folders'] as $subFolder) {
            $this->subFolders[] = new self($subFolder);
        }
        $this->filesDisplayed = (bool) $data['files_displayed'];
        foreach ($data['files'] as $file) {
            $this->files[] = new FolderFile($file);
        }
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getOwner(): string
    {
        return $this->owner;
    }

    /**
     * @return string[]
     */
    public function getDivisions(): array
    {
        return $this->divisions;
    }

    /**
     * @return Folder[]
     */
    public function getSubFolders(): array
    {
        return $this->subFolders;
    }

    /**
     * @return bool
     */
    public function isFilesDisplayed(): bool
    {
        return $this->filesDisplayed;
    }

    /**
     * @return FolderFile[]
     */
    public function getFiles(): array
    {
        return $this->files;
    }

    public static function createFromResponse(ResponseInterface $response): self
    {
        $data = json_decode((string) $response->getBody(), true);

        return new self($data);
    }
}

/*
 *  "path":"Archief",
 * "uuid":"C3F074E1-A1A6-4E14-9F15-B78CAA9A83B5",
 * "owner":"isset-uuid",
 * "name":"Archief",
 * "divisions":[
 * "dev-aaaa",
 * "BD0322B0-1D0A-4938-834A-A19BECCF6E14"
 * ],
 * "sub_folders":[  ],
 * "files_displayed":false,
 * "files":[  ]
 */
