<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\File;

class FileTag
{
    /**
     * @var array
     */
    private $data;
    /**
     * @var int
     */
    private $id;
    /**
     * @var string
     */
    private $tag;

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->id = $data['id'];
        $this->tag = $data['tag'];
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getTag(): string
    {
        return $this->tag;
    }
}
