<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\File;

use Psr\Http\Message\ResponseInterface;

class FileData
{
    /**
     * @var string
     */
    private $id;
    /**
     * @var string
     */
    private $type;
    /**
     * @var string
     */
    private $url;
    /**
     * @var string
     */
    private $urlSecured;

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->id = (string) $data['id'];
        $this->type = (string) $data['type'];
        $this->url = (string) $data['url'];
        $this->urlSecured = (string) $data['url_secured'];
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return $this->url;
    }

    /**
     * @return string
     */
    public function getUrlSecured(): string
    {
        return $this->urlSecured;
    }

    public static function createFromResponse(ResponseInterface $response): self
    {
        $data = json_decode((string) $response->getBody(), true);

        return new self($data);
    }
}
