<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\Folder;

use Psr\Http\Message\ResponseInterface;

class FolderData
{
    private $folders = [];
    private $shared = [];

    /**
     * @var array
     */
    private $data;

    public function __construct(array $data)
    {
        $this->data = $data;
        foreach ($data['folders'] as $folder) {
            $this->folders[] = new Folder($folder);
        }
        foreach ($data['shared'] as $folder) {
            $this->shared[] = new Folder($folder);
        }
    }

    public static function createFromResponse(ResponseInterface $response): self
    {
        $data = json_decode((string) $response->getBody(), true);

        return new self($data);
    }
}
