<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\File;

use DateTime;
use Psr\Http\Message\ResponseInterface;

class FileSearch
{
    /**
     * @var array
     */
    private $data;
    /**
     * @var string
     */
    private $uuid;
    /**
     * @var string
     */
    private $state;
    /**
     * @var int|null
     */
    private $size;
    /**
     * @var string
     */
    private $name;
    /**
     * @var DateTime
     */
    private $created;
    /**
     * @var DateTime
     */
    private $updated;
    /**
     * @var string|null
     */
    private $image;
    /**
     * @var string|null
     */
    private $preview;
    /**
     * @var string|null
     */
    private $previewSecured;
    /**
     * @var float|null
     */
    private $duration;
    /**
     * @var string|null
     */
    private $extension;
    /**
     * @var bool
     */
    private $createsPreview;
    /**
     * @var string
     */
    private $previewState;

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->uuid = $data['uuid'];
        $this->state = $data['state'];
        $this->size = null === $data['size'] ? null : (int) $data['size'];
        $this->name = $data['name'];
        $this->created = new DateTime($data['created']);
        $this->updated = new DateTime($data['updated']);
        $this->image = $data['image'];
        $this->preview = $data['preview'];
        $this->previewSecured = $data['preview_secured'];
        $this->duration = null === $data['duration'] ? null : (float) $data['duration'];
        $this->extension = $data['extension'];
        $this->createsPreview = (bool) $data['creates_preview'];
        $this->previewState = $data['preview_state'];
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return DateTime
     */
    public function getCreated(): DateTime
    {
        return $this->created;
    }

    /**
     * @return DateTime
     */
    public function getUpdated(): DateTime
    {
        return $this->updated;
    }

    /**
     * @return null|string
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * @return null|string
     */
    public function getPreview()
    {
        return $this->preview;
    }

    /**
     * @return null|string
     */
    public function getPreviewSecured()
    {
        return $this->previewSecured;
    }

    /**
     * @return float|null
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * @return null|string
     */
    public function getExtension()
    {
        return $this->extension;
    }

    /**
     * @return bool
     */
    public function isCreatesPreview(): bool
    {
        return $this->createsPreview;
    }

    /**
     * @return string
     */
    public function getPreviewState(): string
    {
        return $this->previewState;
    }

    /**
     * @param ResponseInterface $response
     *
     * @return FileSearch[]
     */
    public static function createMultiFromResponse(ResponseInterface $response): array
    {
        $items = json_decode((string) $response->getBody(), true);
        $return = [];
        foreach ($items as $item) {
            $return[] = new self($item);
        }

        return $return;
    }

    /**
     * @param ResponseInterface $response
     *
     * @return FileSearch
     */
    public static function createFromResponse(ResponseInterface $response): self
    {
        $data = json_decode((string) $response->getBody(), true);

        return new self($data);
    }
}
