<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient\Response\File;

class FileMeta
{
    /**
     * @var array
     */
    private $data;
    /**
     * @var int
     */
    private $id;
    /**
     * @var string
     */
    private $key;
    /**
     * @var string
     */
    private $value;

    public function __construct(array $data)
    {
        $this->data = $data;
        $this->id = $data['id'];
        $this->key = $data['key'];
        $this->value = $data['value'];
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }
}
