<?php

declare(strict_types=1);

namespace IssetBV\VideoArchiveClient;

use IssetBV\Http\Client\ClientInterface;
use Psr\Http\Message\ResponseInterface;

class VideoArchiveHttpClient
{
    /**
     * @var string
     */
    private $baseUrl;
    /**
     * @var ClientInterface
     */
    private $client;

    public function __construct(ClientInterface $client, string $baseUrl)
    {
        $this->baseUrl = rtrim($baseUrl, '/');
        $this->client = $client;
    }

    public function call(string $method, string $uri, array $headers = [], $body = null, array $query = []): ResponseInterface
    {
        $url = $this->withBaseUrl($uri);
        if (\count($query) > 0) {
            if (false === mb_strpos($url, '?')) {
                $url .= '?';
            } elseif ('?' !== $url[mb_strlen($url) - 1]) {
                $url .= '&';
            }
            $url .= http_build_query($query);
        }
        $request = $this->client->create($method, $url, $headers, $body);

        return $this->client->call($request);
    }

    private function withBaseUrl(string $url): string
    {
        return $this->baseUrl . '/' . ltrim($url, '/');
    }
}
