Creating an X-Auth Token
========================

```php
    $connection = new CurlPost();
    $creater = new TokenCreater($connection, 'https://my.videoarchive.io/');
    $xAuthToken = $creater->getToken(
        $consumerKey,
        $privateKey
        );
    print_r($token);
```

Simple Request
==============

```php
        $connection = new CurlPost();
        $client = new VideoArchiveClient($connection, $xAuthToken);
        
        $payloadFactory = new PayloadFactory('https://my.videoarchive.io/');
        $payload = $payloadFactory->post('api/transcode/import');
        $payload->overwritePostData([
            'name' => 'test',
            'location_source' => [
                'type' => 'ftp',
                'data' => 'ftp://user:pwd@ftp.domain.tld/dir/ . $filename,
                'callback_url' => null,
            ],
            'folder_uuid' => null,
            'preview' => 1,
            'callback_url' => null,
        ]);


        try {
            /** @var \IssetBV\VideoArchiveClient\Connection\Curl\CurlResponse $response */
            $response = $client->sendPayloadWithHeaders($payload);
            print_r($response);
        } catch (\Exception $e) {
            print_r($e);
        }
```