#!/bin/bash

# We need to install dependencies only for Docker
[[ ! -e /.dockerenv ]] && exit 0

set -xe

# Install git and unzip (the php image doesn't have it) which is required by composer
apt-get update -yqq
apt-get install git zlib1g-dev unzip -yqq
docker-php-ext-install zip

# Need this for PHPUnit-Test-Coverage
pecl install xdebug
docker-php-ext-enable xdebug

# Fix timezone
cp ci/php.gitlab-ci.ini /usr/local/etc/php/conf.d/php.ini

# Install if composer doesn't exist yet
if [ ! -f /cache/composer.phar ]
then
  curl -k -sS https://getcomposer.org/installer | php
  mv composer.phar /cache/composer.phar
fi

php /cache/composer.phar config cache-files-dir /cache/composer
