<?php

namespace IssetBV\VideoArchiveClient;

use IssetBV\VideoArchiveClient\Connection\ConnectionInterface;
use IssetBV\VideoArchiveClient\Payload\Payload;
use IssetBV\VideoArchiveClient\Connection\ResponseInterface;

/**
 * Class VideoArchiveClient.
 *
 * @author Felix Balfoort <felix@isset.nl>
 */
class VideoArchiveClient
{
    /**
     * @var ConnectionInterface
     */
    private $connection;

    /**
     * @var string
     */
    private $xAuthToken;

    /**
     * VideoArchiveClient constructor.
     *
     * @param ConnectionInterface $connection
     * @param string $xAuthToken
     */
    public function __construct(ConnectionInterface $connection, $xAuthToken)
    {
        $this->connection = $connection;
        $this->xAuthToken = $xAuthToken;
    }

    /**
     * Adds the security and Content-Type headers to the payload before sending them.
     *
     * @param Payload $payload
     *
     * @return ResponseInterface
     */
    public function sendPayloadWithHeaders(Payload $payload)
    {
        $this->setRequiredHeadersToPayload($payload);

        return $this->sendPayload($payload);
    }

    /**
     * set the content-type and xauth-token header to a payload.
     *
     * @param Payload $payload
     */
    public function setRequiredHeadersToPayload(Payload $payload)
    {
        $payload->setHeader('Content-Type', 'application/json');
        $payload->setHeader('xauth-token', $this->xAuthToken);
    }

    /**
     * @param Payload $payload
     *
     * @return ResponseInterface
     */
    public function sendPayload(Payload $payload)
    {
        return $this->connection->sendPayload($payload);
    }
}
