<?php

namespace IssetBV\VideoArchiveClient\Security;

use LogicException;

class TokenVault
{
    /**
     * @var string
     */
    private $tokenCacheLocation;

    /**
     * TokenVault constructor.
     *
     * @param string $tokenCacheLocation
     *
     * @throws LogicException in case the tokenCacheLocation is not writable
     */
    public function __construct($tokenCacheLocation)
    {
        $this->tokenCacheLocation = rtrim($tokenCacheLocation, '/') . '/';
        if (false === is_writable($tokenCacheLocation)) {
            throw new LogicException('token cache location isn\'t writable: ' . $tokenCacheLocation);
        }
    }

    /**
     * @param string $key
     * @param string $token
     */
    public function addToken($key, $token)
    {
        file_put_contents($this->getPathForToken($key), $token);
    }

    /**
     * @param string $key
     */
    public function removeToken($key)
    {
        $location = $this->getPathForToken($key);
        if (file_exists($location)) {
            @unlink($location);
        }
    }

    /**
     * @param string $key
     *
     * @throws \LogicException in case the token location points to a file that does not exist
     *
     * @return string
     */
    public function getToken($key)
    {
        $location = $this->getPathForToken($key);
        if (false === file_exists($location)) {
            throw new LogicException('token not found');
        }

        return file_get_contents($location);
    }

    /**
     * @param string $key
     *
     * @return string
     */
    public function getPathForToken($key)
    {
        return $this->tokenCacheLocation . sha1($key);
    }
}
