<?php

namespace IssetBV\VideoArchiveClient\Security;

use IssetBV\VideoArchiveClient\Connection\ConnectionInterface;
use IssetBV\VideoArchiveClient\Payload\LoginPayload;
use IssetBV\VideoArchiveClient\Connection\ResponseException;

/**
 * @author Tim Fennis <tim@isset.nl>
 * @author Felix Balfoort <felix@isset.nl>
 */
class TokenCreator
{
    /**
     * @var ConnectionInterface
     */
    private $connection;

    /**
     * @var string
     */
    private $baseUrl;

    /**
     * TokenCreator constructor.
     *
     * @param ConnectionInterface $connection
     * @param string $baseUrl
     */
    public function __construct(ConnectionInterface $connection, $baseUrl)
    {
        $this->connection = $connection;
        $this->baseUrl = rtrim($baseUrl, '/');
    }

    /**
     * @param string $consumerKey
     * @param string $privateKey
     *
     * @throws ResponseException
     *
     * @return string
     */
    public function getToken($consumerKey, $privateKey)
    {
        $login = new LoginPayload($this->baseUrl . '/api/login', $consumerKey, $privateKey);
        $response = $this->connection->sendPayload($login);
        $statusCode = $response->getStatusCode();
        if ($statusCode >= 200 && $statusCode < 300) {
            return $response->getJsonResponse()['token'];
        } else {
            throw new ResponseException($response);
        }
    }
}
