<?php

namespace IssetBV\VideoArchiveClient\Payload;

/**
 * Class LoginPayload.
 *
 * @author Felix Balfoort <felix@isset.nl>
 */
class LoginPayload extends Payload
{
    /**
     * @var string
     */
    private $consumerKey;

    /**
     * @var string
     */
    private $privateKey;

    /**
     * LoginPayload constructor.
     *
     * @param string $url
     * @param string $consumerKey
     * @param string $privateKey
     */
    public function __construct($url, $consumerKey, $privateKey)
    {
        parent::__construct($url);
        $this->consumerKey = $consumerKey;
        $this->privateKey = $privateKey;
    }

    /**
     * @return array
     */
    public function getPostData()
    {
        $time = time();
        $this->setHeader('Content-Type', 'application/json');
        $this->setPostData('consumer_key', $this->consumerKey);
        $this->setPostData('time', $time);
        $this->setPostData('hash', crypt($time . '' . $this->privateKey . '' . $this->consumerKey, '$6$rounds=9001$' . $this->consumerKey . '$'));

        return parent::getPostData();
    }
}
