<?php

namespace IssetBV\VideoArchiveClient\Connection;

/**
 * Interface ResponseInterface.
 *
 * @author Felix Balfoort <felix@isset.nl>
 * @author Tim Fennis <tim@isset.nl>
 */
interface ResponseInterface
{
    /**
     * Returns the HTTP status code associated with this response
     *
     * @return int
     */
    public function getStatusCode();

    /**
     * Returns the response content as a string (does not assume the content has a specific format)
     *
     * @return string
     */
    public function getContent();

    /**
     * Returns the response content as an array (assumes the content is json)
     *
     * @return array
     */
    public function getJsonResponse();

    /**
     * Get the value for a header from the response. Returns false if no such value exists
     *
     * @param string $name
     *
     * @return bool|string
     */
    public function getHeaderByName($name);
}
