<?php

namespace IssetBV\VideoArchiveClient\Connection;

use Exception;

/**
 * Class ResponseException.
 *
 * @author Felix Balfoort <felix@isset.nl>
 */
class ResponseException extends Exception
{
    /**
     * @var string
     */
    protected $response;

    /**
     * ResponseException constructor.
     *
     * @param string $response
     * @param string|null $message
     * @param int|null $code
     * @param Exception|null $previous
     */
    public function __construct($response, $message = null, $code = null, $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->response = $response;
    }

    /**
     * @param ResponseInterface $response
     */
    public function setResponse(ResponseInterface $response)
    {
        $this->response = $response;
    }

    /**
     * @return string
     */
    public function getResponse()
    {
        return $this->response;
    }
}
