<?php

namespace IssetBV\VideoArchiveClient\Connection\Curl;

use IssetBV\VideoArchiveClient\Connection\ResponseInterface;

/**
 * Class CurlResponse.
 *
 * @author Felix Balfoort <felix@isset.nl>
 */
class CurlResponse implements ResponseInterface
{
    /**
     * @var string
     */
    private $content;

    /**
     * @var array
     */
    private $headers;

    /**
     * @var int
     */
    private $statusCode;

    /**
     * CurlResponse constructor.
     *
     * @param int $statusCode
     * @param array $headers
     * @param string $content
     */
    public function __construct($statusCode, $headers, $content)
    {
        $this->statusCode = $statusCode;
        $this->headers = $headers;
        $this->content = $content;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @return int
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }

    /**
     * @return mixed
     */
    public function getJsonResponse()
    {
        return json_decode($this->content, true);
    }

    /**
     * @param string $name
     *
     * @return bool|string
     */
    public function getHeaderByName($name)
    {
        $headers = explode("\n", $this->headers);

        foreach ($headers as $header) {
            if (empty($header)) {
                continue;
            }
            $keyVal = explode(': ', $header);
            if ($keyVal[0] === $name) {
                return trim($keyVal[1], " \t\n\r\0\x0B");
            }
        }

        return false;
    }
}
