<?php
namespace IssetBV\VideoArchiveClient\Security;

use IssetBV\VideoArchiveClient\Connection\ConnectionInterface;
use IssetBV\VideoArchiveClient\Payload\LoginPayload;
use IssetBV\VideoArchiveClient\Connection\ResponseException;

class TokenCreater
{

    /**
     * @var ConnectionInterface
     */
    private $connection;

    private $baseUrl;

    public function __construct(ConnectionInterface $connection, $baseUrl)
    {
        $this->connection = $connection;
        $this->baseUrl = rtrim($baseUrl, '/');
    }

    /**
     * @param string $consumerKey
     * @param string $privateKey
     * @return string 
     * @throws ResponseException
     */
    public function getToken($consumerKey, $privateKey)
    {
        $login = new LoginPayload($this->baseUrl . '/api/login', $consumerKey, $privateKey);
        $response = $this->connection->sendPayload($login);
        if ($response->getStatusCode() >= 200 && $response->getStatusCode() < 300) {
            return $response->getJsonResponse()['token'];
        } else {
            throw new ResponseException($response);
        }
    }
}