<?php
namespace IssetBV\VideoArchiveClient\Connection\Curl;

use IssetBV\VideoArchiveClient\Payload\Payload;
use IssetBV\VideoArchiveClient\Connection\ConnectionInterface;

class CurlPost implements ConnectionInterface
{

    public function sendPayload(Payload $payload)
    {
        $ch = curl_init($payload->getUrl());
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        if (in_array($payload->getMethod(), [
            'post',
            'put'
        ])) {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload->getPostData()));
        }
        
        $headers = $payload->getHeaders();
        if (! empty($headers)) {
            $curlHeaders = array();
            foreach ($headers as $key => $value) {
                $curlHeaders[] = $key . ': ' . $value;
            }
            curl_setopt($ch, CURLOPT_HTTPHEADER, $curlHeaders);
        }
        
        $content = curl_exec($ch);
        
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $retHeaders = substr($content, 0, $header_size);
        $body = substr($content, $header_size);
        
        return new CurlResponse(curl_getinfo($ch, CURLINFO_HTTP_CODE), $retHeaders, $body);
    }
}