<?php
namespace IssetBV\VideoArchiveClient\Security;

use LogicException;

class TokenVault
{

    private $tokenCacheLocation;

    public function __construct($tokenCacheLocation)
    {
        $tokenCacheLocation = rtrim($tokenCacheLocation, '/') . '/';
        if (! is_writable($tokenCacheLocation)) {
            throw new LogicException('token cache location isn\'t writable: ' . $tokenCacheLocation);
        }
    }

    public function addToken($key, $token)
    {
        file_put_contents($this->getPathForToken($key), $token);
    }

    public function removeToken($key)
    {
        $location = $this->getPathForToken($key);
        if (file_exists($location)) {
            unlink($location);
        }
    }

    public function getToken($key)
    {
        $location = $this->getPathForToken($key);
        if (! file_exists($location)) {
            throw new LogicException("token not found");
        }
        return file_get_contents($location);
    }

    public function getPathForToken($key)
    {
        return $this->tokenCacheLocation . sha1($key);
    }
}