<?php
namespace IssetBV\FileHandlerClient;

use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\File\Files;
use IssetBV\FileHandlerClient\Folder\Folders;
use IssetBV\FileHandlerClient\Transcode\Transcodes;
use IssetBV\FileHandlerClient\Job\Jobs;
use IssetBV\FileHandlerClient\File\Trash;

class Client
{

    /**
     *
     * @var Folders
     */
    private $folders;

    /**
     * 
     * @var Files
     */
    private $files;

    /**
     *
     * @var Trash
     */
    private $trash;

    /**
     * @var Transcodes
     */
    private $transcodes;

    /**
     * @var Jobs
     */
    private $jobs;

    /**
     * @var GuzzleClient
     */
    private $client;

    private $folderTrash;

    public function __construct($url, $ownerUuid, $currentDivisionUuid, array $divisions, $accountUuid)
    {
        $client = new GuzzleClient([
            'base_url' => $url,
            'defaults' => [
                'headers' => [
                    'x-owner-uuid' => $ownerUuid,
                    'x-account-uuid' => $accountUuid,
                    'x-division-uuid' => $currentDivisionUuid,
                    'Content-Type' => 'application/json'
                ],
                'version' => 1.0
            ]
        ]);
        $this->client = $client;
        $this->files = new Files($client);
        $this->folders = new Folders($client);
        $this->transcodes = new Transcodes($client);
        $this->trash = new Trash($client);
        $this->jobs = new Jobs($client);
        $this->folderTrash = new \IssetBV\FileHandlerClient\Folder\Trash($client);
    }

    /**
     * @return \GuzzleHttp\Client
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @return Jobs
     */
    public function jobs()
    {
        return $this->jobs;
    }

    /**
     * @return Transcodes
     */
    public function transcodes()
    {
        return $this->transcodes;
    }

    /**
     * @return Folders
     */
    public function folders()
    {
        return $this->folders;
    }

    /**
     * @return Files
     */
    public function files()
    {
        return $this->files;
    }

    /**
     * @return Trash
     */
    public function trash()
    {
        return $this->trash;
    }

    public function folderTrash()
    {
        return $this->folderTrash;
    }
}