<?php
namespace IssetBV\FileHandlerClient\Job;

use GuzzleHttp\Client as GuzzleClient;

class Jobs
{

    /**
     * @var GuzzleClient
     */
    private $client;

    public function __construct(GuzzleClient $client)
    {
        $this->client = $client;
    }

    public function getList()
    {
        return json_decode($this->client->get("jobs")
            ->getBody()
            ->getContents());
    }

    public function getById($id)
    {
        return json_decode($this->client->get("job/" . $id)
            ->getBody()
            ->getContents());
    }
}