<?php
namespace IssetBV\FileHandlerClient\Folder;

use DateTime;
use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\File\Location\LocationInterface;

class Trash
{

    /**
     * @var GuzzleClient
     */
    private $client;

    /**
     * @param GuzzleClient $client
     */
    public function __construct(GuzzleClient $client)
    {
        $this->client = $client;
    }

    public function get()
    {
        return json_decode($this->client->get('/trash/folder')
            ->getBody()
            ->getContents());
    }

    public function add(array $uuids)
    {
        return json_decode($this->client->put('/trash/folder', [
            'json' => [
                'folders' => $uuids
            ]
        ])
            ->getBody()
            ->getContents());
    }

    public function emptyBin()
    {
        return json_decode($this->client->delete('/trash/folder')
            ->getBody()
            ->getContents());
    }

    public function remove(array $uuids)
    {
        return json_decode($this->client->patch('/trash/folder', [
            'json' => [
                'folders' => $uuids
            ]
        ])
            ->getBody()
            ->getContents());
    }
}