<?php
namespace IssetBV\FileHandlerClient\Transcode;

use GuzzleHttp\Client as GuzzleClient;

class Transcodes
{

    private $client;

    public function __construct(GuzzleClient $client)
    {
        $this->client = $client;
    }

    public function send(Transcode $transcode)
    {
        $this->client->post("transcode", [
            'json' => $transcode->getRequest()
        ])
            ->getBody()
            ->getContents();
    }

    public function presets()
    {
        return json_decode($this->client->get("transcode/presets")
            ->getBody()
            ->getContents());
    }
}