<?php
namespace IssetBV\FileHandlerClient\Transcode;

use GuzzleHttp\Client as GuzzleClient;

class Transcode
{

    private $request;

    public function __construct($name, $preset, $destination, $folder = null)
    {
        $this->request = [
            'name' => $name,
            'preset' => $preset,
            'folder_uuid' => $folder,
            'destination' => $destination,
            'files' => []
        ];
    }

    public function addFile($fileUuid, array $settings)
    {
        $this->request['files'][] = [
            'file_uuid' => $fileUuid,
            'settings' => $settings
        ];
    }

    public function getRequest()
    {
        return $this->request;
    }
}

