<?php
namespace IssetBV\FileHandlerClient\Folder;

use GuzzleHttp\Client as GuzzleClient;

class Folders
{

    /**
     * @var GuzzleClient
     */
    private $client;

    /**
     * 
     * @var array
     */
    private $defaultDivisions;

    /**
     * @param GuzzleClient $client
     * @param array $defaultDivisions
     */
    public function __construct(GuzzleClient $client, array $defaultDivisions = array())
    {
        $this->client = $client;
        $this->defaultDivisions = $defaultDivisions;
    }

    /**
     * @param string $name
     * @param array $divisions
     * @return \IssetBV\FileHandlerClient\Folder\Folder
     */
    public function create($name, $parentFolderUuid = null)
    {
        $content = $this->client->post("folder", [
            'json' => [
                'name' => $name,
                'divisions' => [],
                'parent_folder_uuid' => $parentFolderUuid
            ]
        ])
            ->getBody()
            ->getContents();
        return new Folder($this->client, $content);
    }

    /**
     * @param string $uuid
     * @param array $divisions
     * @return \IssetBV\FileHandlerClient\Folder\Folder
     */
    public function get($uuid, array $divisions = null)
    {
        return $this->getFolder($uuid, $divisions);
    }

    /**
     * @param string $uuid
     * @return \IssetBV\FileHandlerClient\Folder\Folder
     */
    public function getFolder($uuid)
    {
        $content = $this->client->get("folder/" . $uuid)
            ->getBody()
            ->getContents();
        return new Folder($this->client, $content);
    }

    /**
     * @return multitype:\IssetBV\FileHandlerClient\Folder\Folder
     */
    public function getSharedList()
    {
        $data = $this->client->get("folders/shared")
            ->getBody()
            ->getContents();
        $folders = json_decode($data);
        $return = array();
        
        foreach ($folders as $folder) {
            $return[] = new Folder($this->client, $folder);
        }
        
        return $return;
    }

    /**
     * @param array $divisions
     * @return multitype:\IssetBV\FileHandlerClient\Folder\Folder
     */
    public function getList()
    {
        $data = $this->client->get("folders")
            ->getBody()
            ->getContents();
        $folders = json_decode($data);
        $return = array();
        
        foreach ($folders as $folder) {
            $return[] = new Folder($this->client, $folder);
        }
        
        return $return;
    }
}