<?php
namespace IssetBV\FileHandlerClient;

use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\File\Files;
use IssetBV\FileHandlerClient\Folder\Folders;
use IssetBV\FileHandlerClient\Transcode\Transcodes;
use IssetBV\FileHandlerClient\Job\Jobs;

class Client
{

    /**
     *
     * @var Folders
     */
    private $folders;

    /**
     * 
     * @var Files
     */
    private $files;

    /**
     * @var Transcodes
     */
    private $transcodes;

    /**
     * @var Jobs
     */
    private $jobs;

    /**
     * @var GuzzleClient
     */
    private $client;

    public function __construct($url, $ownerUuid, $currentDivisionUuid, array $divisions, $accountUuid)
    {
        $client = new GuzzleClient([
            'base_url' => $url,
            'defaults' => [
                'headers' => [
                    'x-owner-uuid' => $ownerUuid,
                    'x-account-uuid' => $accountUuid,
                    'x-division-uuid' => $currentDivisionUuid,
                    'Content-Type' => 'application/json'
                ],
                'query' => [
                    'divisions' => $divisions
                ]
            ]
        ]);
        $this->client = $client;
        $this->files = new Files($client, $divisions);
        $this->folders = new Folders($client, $divisions);
        $this->transcodes = new Transcodes($client);
        $this->jobs = new Jobs($client);
    }

    /**
     * @return \GuzzleHttp\Client
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @return Jobs
     */
    public function jobs()
    {
        return $this->jobs;
    }

    /**
     * @return Transcodes
     */
    public function transcodes()
    {
        return $this->transcodes;
    }

    /**
     * @return Folders
     */
    public function folders()
    {
        return $this->folders;
    }

    /**
     * @return Files
     */
    public function files()
    {
        return $this->files;
    }
}