<?php
namespace IssetBV\FileHandlerClient;

use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\File\Files;
use IssetBV\FileHandlerClient\Folder\Folders;
use IssetBV\FileHandlerClient\Transcode\Transcodes;
use IssetBV\FileHandlerClient\Job\Jobs;

class Client
{

    /**
     *
     * @var Folders
     */
    private $folders;

    /**
     * 
     * @var Files
     */
    private $files;

    /**
     * @var Transcodes
     */
    private $transcodes;

    /**
     * @var Jobs
     */
    private $jobs;

    public function __construct($url, $ownerUuid, $currentDivisionUuid, array $divisions = array(), $creatorUuid = null)
    {
        $client = new GuzzleClient([
            'base_url' => $url,
            'defaults' => [
                'headers' => [
                    'x-owner-uuid' => $ownerUuid,
                    'x-creator-uuid' => $creatorUuid,
                    'x-account-uuid' => $creatorUuid,
                    'x-division-uuid' => $currentDivisionUuid,
                    'Content-Type' => 'application/json'
                ]
            ]
        ]);
        $this->files = new Files($client, $divisions);
        $this->folders = new Folders($client, $divisions);
        $this->transcodes = new Transcodes($client);
        $this->jobs = new Jobs($client);
    }

    /**
     * @return Jobs
     */
    public function jobs()
    {
        return $this->jobs;
    }

    /**
     * @return Transcodes
     */
    public function transcodes()
    {
        return $this->transcodes;
    }

    /**
     * @return Folders
     */
    public function folders()
    {
        return $this->folders;
    }

    /**
     * @return Files
     */
    public function files()
    {
        return $this->files;
    }
}