<?php
namespace IssetBV\FileHandlerClient\File;

use DateTime;
use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\Folder\Folder;

class File
{

    /**
     * @var GuzzleClient
     */
    private $client;

    private $uuid;

    private $name;

    private $owner;

    private $state;

    private $mimeType;

    private $size;

    /**
     * @var Folder
     */
    private $folder;

    private $meta;

    private $tags;

    private $extra;

    /**
     * 
     * @var DateTime
     */
    private $created;

    public function __construct($client, $data)
    {
        $this->client = $client;
        $this->setFromData($data);
    }

    private function setFromData($data)
    {
        if (is_string($data)) {
            $data = json_decode($data);
        }
        $this->uuid = $data->uuid;
        $this->name = $data->name;
        $this->owner = $data->owner;
        $this->state = $data->state;
        $this->mimeType = $data->mime_type;
        $this->size = $data->size;
        
        $this->folder = new Folder($this->client, $data->folder);
        
        $this->meta = $data->meta;
        $this->tags = $data->tags;
        $this->extra = $data->extra;
        $this->created = new DateTime($data->created);
    }

    public function rename($name)
    {
        $request = $this->client->patch('file/' . $this->uuid, [
            'json' => [
                'name' => $name
            ]
        ]);
        $this->setFromData($request->getBody()
            ->getContents());
    }

    public function addMeta($key, $value)
    {
        $this->setFromData($this->client->post('file/' . $this->uuid . '/meta', [
            'json' => [
                'key' => $key,
                'value' => $value
            ]
        ])
            ->getBody()
            ->getContents());
    }

    public function addTag($tag)
    {
        $this->setFromData($this->client->post('file/' . $this->uuid . '/tag', [
            'json' => [
                'value' => $tag
            ]
        ])
            ->getBody()
            ->getContents());
    }

    public function moveFolder($folder)
    {
        if ($folder instanceof Folder) {
            $folder = $folder->getUuid();
        }
        $this->setFromData($this->client->put('file/' . $this->uuid . '/move/' . $folder)
            ->getBody()
            ->getContents());
    }

    public function getUuid()
    {
        return $this->uuid;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getOwner()
    {
        return $this->owner;
    }

    public function getState()
    {
        return $this->state;
    }

    public function getMimeType()
    {
        return $this->mimeType;
    }

    public function getSize()
    {
        return $this->size;
    }

    public function getFolder()
    {
        return $this->folder;
    }

    public function getMeta()
    {
        return $this->meta;
    }

    public function getTags()
    {
        return $this->tags;
    }

    public function getExtra()
    {
        return $this->extra;
    }

    public function getCreated()
    {
        return $this->created;
    }
}