<?php
namespace IssetBV\FileHandlerClient\Folder;

use GuzzleHttp\Client as GuzzleClient;

class Folders
{

    /**
     * @var GuzzleClient
     */
    private $client;

    /**
     * 
     * @var array
     */
    private $defaultDivisions;

    public function __construct(GuzzleClient $client, array $defaultDivisions = array())
    {
        $this->client = $client;
        $this->defaultDivisions = $defaultDivisions;
    }

    /**
     * 
     * @param string $name
     * @param array $divisions
     * @return \IssetBV\FileHandlerClient\Folder\Folder
     */
    public function create($name, $parentFolderUuid = null, array $divisions = null)
    {
        if ($divisions === null) {
            $divisions = $this->defaultDivisions;
        }
        $content = $this->client->post("folder", [
            'json' => [
                'name' => $name,
                'divisions' => $divisions,
                'parent_folder_uuid' => $parentFolderUuid
            ]
        ])
            ->getBody()
            ->getContents();
        return new Folder($this->client, $content);
    }

    /**
     * 
     * @param string $uuid
     * @param array $divisions
     * @return \IssetBV\FileHandlerClient\Folder\Folder
     */
    public function get($uuid, array $divisions = null)
    {
        return $this->getFolder($uuid, $divisions);
    }

    /**
     * 
     * @param string $uuid
     * @param array $divisions 
     * @return \IssetBV\FileHandlerClient\Folder\Folder
     */
    public function getFolder($uuid, array $divisions = null)
    {
        if ($divisions === null) {
            $divisions = $this->defaultDivisions;
        }
        $content = $this->client->get("folder/" . $uuid, [
            'query' => [
                'divisions' => $divisions
            ]
        ])
            ->getBody()
            ->getContents();
        return new Folder($this->client, $content);
    }

    public function getList(array $divisions = null)
    {
        if ($divisions === null) {
            $divisions = $this->defaultDivisions;
        }
        $data = $this->client->get("folders", [
            'query' => [
                'divisions' => $divisions
            ]
        ])
            ->getBody()
            ->getContents();
        $folders = json_decode($data);
        $return = array();
        
        foreach ($folders as $folder) {
            $return[] = new Folder($this->client, $folder);
        }
        
        return $return;
    }
}