<?php
namespace IssetBV\FileHandlerClient\Folder;

use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\File\File;

class Folder
{

    /**
     * @var GuzzleClient
     */
    private $client;

    private $uuid;

    private $owner;

    private $name;

    private $divisions;

    private $children = array();

    public function __construct(GuzzleClient $client, $data)
    {
        $this->client = $client;
        if (! is_object($data)) {
            $data = json_decode($data);
        }
        $this->setData($data);
    }

    private function setData($data)
    {
        $this->uuid = $data->uuid;
        $this->owner = $data->owner;
        $this->name = $data->name;
        $this->divisions = $data->divisions;
        
        foreach ($data->sub_folders as $subFolder) {
            $this->children[] = new Folder($this->client, $subFolder);
        }
    }

    public function getFiles()
    {
        $data = $this->client->get('folder/' . $this->uuid . '/files')
            ->getBody()
            ->getContents();
        $files = json_decode($data);
        $return = array();
        foreach ($files as $file) {
            $return[] = new File($this->client, $file);
        }
        return $return;
    }

    public function move($toFolder)
    {
        if ($toFolder instanceof Folder) {
            $toFolder = $toFolder->getUuid();
        }
        $data = $this->client->put('folder/' . $this->uuid . '/move/' . $toFolder)
            ->getBody()
            ->getContents();
        $folder = json_decode($data);
        $this->setData($folder);
    }

    public function getUuid()
    {
        return $this->uuid;
    }

    public function getOwner()
    {
        return $this->owner;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getDivisions()
    {
        return $this->divisions;
    }

    public function getChildren()
    {
        return $this->children;
    }
}