<?php
namespace IssetBV\FileHandlerClient\File;

use GuzzleHttp\Client as GuzzleClient;

class File
{

    /**
     * @var GuzzleClient
     */
    private $client;

    private $uuid;

    private $name;

    private $owner;

    private $state;

    private $mimeType;

    private $size;

    private $folder;

    private $meta;

    private $tags;

    public function __construct($client, $data)
    {
        $this->client = $client;
        $this->setFromData($data);
    }

    private function setFromData($data)
    {
        if (is_string($data)) {
            $data = json_decode($data);
        }
        $this->uuid = $data->uuid;
        $this->name = $data->name;
        $this->owner = $data->owner;
        $this->state = $data->state;
        $this->mimeType = $data->mime_type;
        $this->size = $data->size;
        $this->folder = $data->folder;
        $this->meta = $data->meta;
        $this->tags = $data->tags;
    }

    public function addMeta($key, $value)
    {
        $this->setFromData($this->client->post('file/' . $this->uuid . '/meta', [
            'json' => [
                'key' => $key,
                'value' => $value
            ]
        ])
            ->getBody()
            ->getContents());
    }

    public function addTag($tag)
    {
        $this->setFromData($this->client->post('file/' . $this->uuid . '/tag', [
            'json' => [
                'value' => $tag
            ]
        ])
            ->getBody()
            ->getContents());
    }

    public function getUuid()
    {
        return $this->uuid;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getOwner()
    {
        return $this->owner;
    }

    public function getState()
    {
        return $this->state;
    }

    public function getMimeType()
    {
        return $this->mimeType;
    }

    public function getSize()
    {
        return $this->size;
    }

    public function getFolder()
    {
        return $this->folder;
    }

    public function getMeta()
    {
        return $this->meta;
    }

    public function getTags()
    {
        return $this->tags;
    }
}