<?php
namespace IssetBV\FileHandlerClient;

use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\File\Files;
use IssetBV\FileHandlerClient\Folder\Folders;

class Client
{

    /**
     *
     * @var Folders
     */
    private $folders;

    /**
     * 
     * @var Files
     */
    private $files;

    public function __construct($url, $ownerUuid, array $divisions = array())
    {
        $client = new GuzzleClient([
            'base_url' => $url,
            'defaults' => [
                'headers' => [
                    'x-owner-uuid' => $ownerUuid,
                    'Content-Type' => 'application/json'
                ]
            ]
        ]);
        $this->files = new Files($client, $divisions);
        $this->folders = new Folders($client, $divisions);
    }

    /**
     * @return \IssetBV\FileHandlerClient\Folder\Folders
     */
    public function folders()
    {
        return $this->folders;
    }

    /**
     * @return \IssetBV\FileHandlerClient\File\Files
     */
    public function files()
    {
        return $this->files;
    }
}