<?php
namespace IssetBV\FileHandlerClient\Folder;

use GuzzleHttp\Client as GuzzleClient;

class Folders
{

    /**
     * @var GuzzleClient
     */
    private $client;

    public function __construct(GuzzleClient $client)
    {
        $this->client = $client;
    }

    /**
     * 
     * @param string $uuid
     * @return \IssetBV\FileHandlerClient\Folder\Folder
     */
    public function getFolder($uuid)
    {
        $content = $this->client->get("folder/" . $uuid)
            ->getBody()
            ->getContents();
        return new Folder($this->client, $content);
    }

    public function getList()
    {
        $data = $this->client->get("folders")
            ->getBody()
            ->getContents();
        $folders = json_decode($data);
        $return = array();
        
        foreach ($folders as $folder) {
            $return = new Folder($this->client, $folder);
        }
        
        return $return;
    }
}