<?php
namespace IssetBV\FileHandlerClient\File;

use GuzzleHttp\Client as GuzzleClient;
use IssetBV\FileHandlerClient\File\Location\LocationInterface;

class Files
{

    /**
     * @var GuzzleClient
     */
    private $client;

    public function __construct(GuzzleClient $client)
    {
        $this->client = $client;
    }

    /**
     * 
     * @param unknown $uuid
     * @return \IssetBV\FileHandlerClient\File\File
     */
    public function get($uuid)
    {
        $data = $this->client->get('file/' . $this->uuid)
            ->getBody()
            ->getContents();
        return new File($this->client, $data);
    }

    /**
     * 
     * @param string $name
     * @param LocationInterface $locationSource
     * @param string $folderUuid
     * @return \IssetBV\FileHandlerClient\File\File
     */
    public function add($name, LocationInterface $locationSource, $folderUuid = null)
    {
        $data = $this->client->post('file', [
            'json' => [
                'name' => $name,
                'location_source' => $locationSource->toArray(),
                'folder_uuid' => $folderUuid
            ]
        ])
            ->getBody()
            ->getContents();
        return new File($this->client, $data);
    }
}